---
aliases:
  - Obsidian Tips
  - Obsidian Help
---
### To Ruchi - How to access my notes in Obsidian
1. Obsidian vault is encrypted on their server. It is just a file-folder system on local device. 
2. Log in to my Obsidian account and use encryption key to access my Obsidian Vault. These details are in my KeePass. 
3. [[Root]] has shortcut to my major life areas that are documented. 
4. You can navigate from left pane folder view as well.
### Plug-ins 
##### Tasks plug-in
[Combining Filters - Tasks User Guide - Obsidian Publish](https://publish.obsidian.md/tasks/Queries/Combining+Filters)
##### DataView plugin
Video: [Automate Your Obsidian Vault With Dataview](https://www.youtube.com/watch?v=8yjNuiSBSAM&ab_channel=FromSergio)
### Useful shortcuts: 
- Ctrl + F - global search within Obsidian
- Ctrl + L - convert any line of text into task
- Ctrl + P - open command box
- Ctrl + O - open another note quickly
- Ctrl + Y - fold all headings
### Markdown formatting
Table format
```
| Syntax      | Description |
| ----------- | ----------- |
| Header      | Title       |
| Paragraph   | Text        |
```
Strikethrough ~~Text~~
Bold **Text**
Italic *Text*
code block ```code block``` 
> text block as a quote

### YAML
##### Using YAML in frontmatter
To create a valid YAML block, we need to meet these three requirements:
1. A YAML block needs **triple dashes** at the start and end to be read by Obsidian (and other apps)
2. It also needs to be placed at the very top of the file.
3. Add space between the colon and the beginning of the value for each key-value pair.
	Examples - 3 ways of creating multiple tags
		---
		tags: content_video, content_blog  
		tags: [content_video, content_blog]  
		tags:
			- content_video
			- content_blog
			- status_ongoing	
			- category_productivity
			- pkm
			- obsidian
		---

### Actions
##### URI commands in Obsidian
Refer: [Using Obsidian URI - Obsidian Help](https://help.obsidian.md/Advanced+topics/Using+Obsidian+URI)
Obsidian URIs are typically in this format:
```
obsidian://action?param1=value&param2=value
```
The `action` is usually the action that you would like to perform
- Action: **file**
  Example - obsidian://open?vault=myVault1&file=Quick%20capture.md
- Action: **new**
  Example:
```
obsidian://new?vault=myVault1&name=New%20note
```
This opens the vault `myVault1`, and creates a new note called `New note`.

### Links
##### Link to a heading in a note
You can link to specific headings in notes, also known as _anchor links_.
To link to a heading, add a hashtag (`#`) at the end of the link destination, followed by the heading text.
For example, `[[Three laws of motion#Second law]]`.
You can add multiple hashtags for each subheading.
For example, `[[My note#Heading 1#Heading 2]]`.

##### Linking blocks in a note
A block is a unit of text in your note, for example a paragraph, block quote, or even a list item.
You can link to a block by adding `#^` at the end of your link destination followed by a unique block identifier, for example, `[[2023-01-01#^37066d]]`.
Fortunately, you don't need to know the identifier. When you type the caret (`^`), you can select the block from a list of suggestions to insert the right identifier.

You can also create human-readable block identifiers by adding `^quote-of-the-day` at the end of a block. Note the blank space before the caret. Now you can instead link to the block by typing `[[2023-01-01#^quote-of-the-day]]`.

##### Tags vs Links
In Obsidian, tags are actually a kind of link!
What Obsidian calls a link can be defined as: “A connection from one note to another note”.
In Obsidian, a tag is: “A connection from a note to an idea”.
Every note in your vault is a “node”, as you see when you open the graph view. Every tag is also a node, just with no file behind it! You can see this within the graph view by turning on “Tags” under the “Filters” option!
This means a few things:
1.  You don’t actually have to choose between tags and links for organization! They’re complimentary, and we’ll go over why in the next sections.
2.  You can’t go _very_ wrong in whichever path you choose. The two ideas are so similar that there is almost always a way to make tags or links work _mostly_ like the other. In other words: you can achieve nearly all the same functionality with either tags or links… **the differences are almost entirely a matter of convenience!**

**Tags and Links Aren’t Equal, Either**
But tags and links aren’t exactly the same, either, and those matters of convenience can become significant over time. Here is a list of factual differences between the two:
1. Links auto-refactor by default, and tags do not. This is a big one! When you change the name of a file within Obsidian, _all_ links to that folder will automatically change to be pointing to the right place.
2. Click behavior is different. Link is a note, tags are not a note. 
3. Tags can be hierarchical
4. Links can have aliases
5. Tags can be hidden in frontmatter


##### Embed web page in Obsidian 
To embed a web page, add the following in your note and replace the placeholder text with the URL of the web page you want to embed:

```html
<iframe 
  src="https://developer.mozilla.org/en-US/docs/Web/HTML/Element/iframe"></iframe>
```


### Callouts
> [!info]- Title
> Text of the callout which can be collapsible
##### Callout icon descriptors 
- note (blue)
- abstract, summary, tldr (green)
- info (blue)
- todo (blue)
- tip, hint, important (sky blue)
- success, check, done (green)
- question, help, faq (yellow)
- warning, caution, attention (orange)
##### Nested callouts in Obsidian 
You can nest callouts in multiple levels.
You can use collapsible callout design too.

> [!question] Can callouts be nested? 
> > [!todo] Yes!, they can.
> > > [!example]  You can even use multiple layers of nesting.
